/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.mozilla.javascript.tools.debugger.SwingGui;

class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2971618907207577000L;
    private SwingGui debugGui;
    private List<String> expressions;
    private List<String> values;

    public MyTableModel(SwingGui debugGui) {
        this.debugGui = debugGui;
        this.expressions = Collections.synchronizedList(new ArrayList());
        this.values = Collections.synchronizedList(new ArrayList());
        this.expressions.add("");
        this.values.add("");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.expressions.size();
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Expression";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.expressions.get(row);
            }
            case 1: {
                return this.values.get(row);
            }
        }
        return "";
    }

    public void setValueAt(Object value2, int row, int column) {
        switch (column) {
            case 0: {
                String expr2 = value2.toString();
                this.expressions.set(row, expr2);
                String result2 = "";
                if (expr2.length() > 0 && (result2 = this.debugGui.dim.eval(expr2)) == null) {
                    result2 = "";
                }
                this.values.set(row, result2);
                this.updateModel();
                if (row + 1 != this.expressions.size()) break;
                this.expressions.add("");
                this.values.add("");
                this.fireTableRowsInserted(row + 1, row + 1);
                break;
            }
            case 1: {
                this.fireTableDataChanged();
            }
        }
    }

    void updateModel() {
        for (int i = 0; i < this.expressions.size(); ++i) {
            String expr2 = this.expressions.get(i);
            String result2 = "";
            if (expr2.length() > 0) {
                result2 = this.debugGui.dim.eval(expr2);
                if (result2 == null) {
                    result2 = "";
                }
            } else {
                result2 = "";
            }
            result2 = result2.replace('\n', ' ');
            this.values.set(i, result2);
        }
        this.fireTableDataChanged();
    }
}

